<?php
session_start();
require_once 'config.php';

// Check if already logged in
if (isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true) {
    header('Location: admin_dashboard.php');
    exit;
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';
    
    try {
        $pdo = getDBConnection();
        $stmt = $pdo->prepare("SELECT * FROM admin_users WHERE username = ? AND is_active = 1");
        $stmt->execute([$username]);
        $admin = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($admin && password_verify($password, $admin['password'])) {
            $_SESSION['admin_logged_in'] = true;
            $_SESSION['admin_id'] = $admin['id'];
            $_SESSION['admin_role'] = $admin['role'];
            $_SESSION['admin_name'] = $admin['full_name'];
            
            // Update last login
            $stmt = $pdo->prepare("UPDATE admin_users SET last_login = NOW() WHERE id = ?");
            $stmt->execute([$admin['id']]);
            
            header('Location: admin_dashboard.php');
            exit;
        } else {
            $error = "Invalid username or password";
        }
    } catch (Exception $e) {
        $error = "Login error: " . $e->getMessage();
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Login - Airwaves Credit Union</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary-blue: #0d3b5d;
            --secondary-blue: #1e4e75;
            --accent-blue: #2c5f8a;
        }
        
        body {
            font-family: 'Poppins', sans-serif;
            background: linear-gradient(135deg, #0d3b5d 0%, #1e4e75 50%, #2c5f8a 100%);
            min-height: 100vh;
            position: relative;
            overflow-x: hidden;
        }
        
        body::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-image: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1200 800" opacity="0.03"><path fill="%23ffffff" d="M0,0H1200V800H0Z"/><circle cx="200" cy="200" r="150" fill="%23ffffff"/><circle cx="800" cy="600" r="120" fill="%23ffffff"/><rect x="400" y="100" width="300" height="200" fill="%23ffffff"/></svg>');
            background-size: cover;
            background-position: center;
            pointer-events: none;
        }
        
        .glass-effect {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(20px);
            border: 1px solid rgba(255, 255, 255, 0.2);
            box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.25);
        }
        
        .floating-element {
            animation: float 6s ease-in-out infinite;
        }
        
        @keyframes float {
            0%, 100% { transform: translateY(0px); }
            50% { transform: translateY(-20px); }
        }
        
        .logo-circle {
            width: 120px;
            height: 120px;
            background: linear-gradient(135deg, #ffffff 0%, #f8fafc 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1), 0 0 0 1px rgba(255, 255, 255, 0.2);
            border: 4px solid rgba(255, 255, 255, 0.3);
        }
        
        .logo-image {
            width: 70px;
            height: 70px;
            object-fit: contain;
            filter: drop-shadow(0 4px 8px rgba(0, 0, 0, 0.2));
        }
        
        .animate-slide-up {
            animation: slideUp 0.5s ease-out;
        }
        
        @keyframes slideUp {
            from {
                transform: translateY(20px);
                opacity: 0;
            }
            to {
                transform: translateY(0);
                opacity: 1;
            }
        }
    </style>
</head>
<body class="min-h-screen flex items-center justify-center p-4">
    <!-- Background Elements -->
    <div class="absolute inset-0 overflow-hidden">
        <div class="absolute -top-40 -right-32 w-80 h-80 bg-white rounded-full opacity-10 floating-element"></div>
        <div class="absolute top-1/2 -left-20 w-60 h-60 bg-white rounded-full opacity-10 floating-element" style="animation-delay: -2s;"></div>
        <div class="absolute bottom-20 right-1/4 w-40 h-40 bg-white rounded-full opacity-10 floating-element" style="animation-delay: -4s;"></div>
    </div>

    <div class="max-w-md w-full relative z-10">
        <div class="glass-effect rounded-3xl p-8 animate-slide-up">
            <!-- Header -->
            <div class="text-center mb-8">
                <!-- Logo with Circular Background -->
                <div class="flex justify-center mb-6">
                    <div class="logo-circle floating-element">
                        <img src="Uploads/images/logo.png" alt="Airwaves Credit Union" class="logo-image">
                    </div>
                </div>
                <h1 class="text-2xl font-bold text-gray-900">Admin Portal</h1>
                <p class="text-gray-600 mt-2">Secure access to administration dashboard</p>
            </div>
            
            <?php if ($error): ?>
                <div class="mb-6 p-4 bg-red-50 border border-red-200 rounded-xl flex items-center">
                    <div class="w-10 h-10 rounded-full bg-red-100 flex items-center justify-center mr-4">
                        <i class="fas fa-exclamation-triangle text-red-600"></i>
                    </div>
                    <div>
                        <p class="font-semibold text-red-800">Login Failed</p>
                        <p class="text-sm text-red-700"><?php echo htmlspecialchars($error); ?></p>
                    </div>
                </div>
            <?php endif; ?>
            
            <!-- Login Form -->
            <form method="POST" action="admin_login.php" class="space-y-6">
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-2">
                        <i class="fas fa-user text-[#0d3b5d] mr-2"></i>
                        Username
                    </label>
                    <div class="relative">
                        <input type="text" name="username" required 
                               class="w-full px-4 py-3 pl-12 border border-gray-300 rounded-xl focus:outline-none focus:ring-2 focus:ring-[#0d3b5d] focus:border-transparent transition-all duration-300 bg-white/80"
                               placeholder="Enter your username">
                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                            <i class="fas fa-user text-gray-400"></i>
                        </div>
                    </div>
                </div>
                
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-2">
                        <i class="fas fa-lock text-[#0d3b5d] mr-2"></i>
                        Password
                    </label>
                    <div class="relative">
                        <input type="password" name="password" required 
                               class="w-full px-4 py-3 pl-12 border border-gray-300 rounded-xl focus:outline-none focus:ring-2 focus:ring-[#0d3b5d] focus:border-transparent transition-all duration-300 bg-white/80"
                               placeholder="Enter your password">
                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                            <i class="fas fa-key text-gray-400"></i>
                        </div>
                    </div>
                </div>
                
                <button type="submit" 
                        class="group relative w-full flex justify-center py-4 px-4 border border-transparent text-lg font-semibold rounded-xl text-white bg-[#0d3b5d] hover:bg-blue-800 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-[#0d3b5d] transition-all duration-300 transform hover:scale-[1.02] shadow-lg">
                    <span class="absolute left-0 inset-y-0 flex items-center pl-4">
                        <i class="fas fa-sign-in-alt text-blue-200 group-hover:text-white transition-colors duration-300"></i>
                    </span>
                    Sign In to Admin Portal
                </button>
            </form>
            
            <!-- Security Notice -->
            <div class="mt-6 text-center">
                <div class="inline-flex items-center space-x-2 text-xs text-blue-200 bg-blue-900/30 px-4 py-2 rounded-full">
                    <i class="fas fa-shield-alt"></i>
                    <span>Restricted access • Authorized personnel only</span>
                </div>
            </div>
        </div>

        <!-- Admin Security Features -->
        <div class="glass-effect rounded-2xl p-6 mt-6">
            <div class="flex items-center justify-between">
                <div class="flex items-center space-x-3">
                    <div class="w-10 h-10 bg-[#0d3b5d] rounded-full flex items-center justify-center">
                        <i class="fas fa-user-shield text-white text-sm"></i>
                    </div>
                    <div>
                        <p class="text-sm font-semibold text-gray-800">Admin Security</p>
                        <p class="text-xs text-gray-600">Enhanced authentication required</p>
                    </div>
                </div>
                <div class="text-2xl">🔐</div>
            </div>
        </div>
    </div>

    <script>
        // Enhanced form interactions
        document.addEventListener('DOMContentLoaded', function() {
            const inputs = document.querySelectorAll('input');
            
            inputs.forEach(input => {
                input.addEventListener('focus', function() {
                    this.parentElement.classList.add('ring-2', 'ring-[#0d3b5d]', 'ring-opacity-20');
                });
                
                input.addEventListener('blur', function() {
                    this.parentElement.classList.remove('ring-2', 'ring-[#0d3b5d]', 'ring-opacity-20');
                });
            });
            
            // Auto-focus username field
            document.querySelector('input[name="username"]')?.focus();
            
            // Add subtle background animation
            const floatingElements = document.querySelectorAll('.floating-element');
            floatingElements.forEach((element, index) => {
                element.style.animationDelay = `${-index * 2}s`;
            });
        });
    </script>
</body>
</html>