<?php
require_once 'config.php';

$errors = [];
$success = false;
$valid_token = false;

$token = $_GET['token'] ?? '';

// Validate token
if (!empty($token)) {
    $token_data = validateToken($token, 'password_reset');
    if ($token_data) {
        $valid_token = true;
        $user_id = $token_data['user_id'];
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!$valid_token) {
        $errors[] = "Invalid or expired reset link.";
    } else {
        $password = $_POST['password'] ?? '';
        $confirm_password = $_POST['confirm_password'] ?? '';
        
        // Validate inputs
        if (empty($password)) {
            $errors[] = "Password is required.";
        } elseif (strlen($password) < 8) {
            $errors[] = "Password must be at least 8 characters long.";
        }
        
        if ($password !== $confirm_password) {
            $errors[] = "Passwords do not match.";
        }
        
        if (empty($errors)) {
            try {
                $pdo = getDBConnection();
                
                // Start transaction
                $