<?php
// Enable error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);

require_once 'config.php';

// Check if user came from registration
if (!isset($_SESSION['registration_email'])) {
    redirect('register.php');
    exit;
}

$email = $_SESSION['registration_email'];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Verification Sent - Airwaves credit union</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-50 min-h-screen flex items-center justify-center">
    <div class="max-w-md w-full bg-white p-8 rounded-lg shadow-md text-center">
        <div class="text-green-600 text-6xl mb-4">✓</div>
        <h2 class="text-2xl font-bold mb-4">Registration Successful!</h2>
        <p class="mb-4">We've sent a verification email to:</p>
        <p class="font-bold mb-4"><?php echo htmlspecialchars($email); ?></p>
        <p class="mb-6 text-gray-600">Please check your email and click the verification link to activate your account.</p>
        <a href="login.php" class="bg-green-800 text-white px-6 py-2 rounded-lg hover:bg-green-700">
            Continue to Login
        </a>
    </div>
</body>
</html>
<?php
// Clear the session
unset($_SESSION['registration_email']);
?>